#!/bin/env ruby
# encoding: utf-8
require 'rubygems'
require 'rspec'
require 'watir-webdriver'
require 'page-object'
require 'oci8'

require_relative '../../module/DriverUtility'
require_relative '../rspec_helper'
require_relative '../../pages/landing'
require_relative '../../pages/login'
require_relative '../../pages/eula'
require_relative '../../common/common'
require_relative '../../pages/app_options_menu'
require_relative '../../pages/landing_appointments'
require_relative '../../module/database/OracleUtility'
require_relative '../../pages/appointments/new_appointment_request'
require_relative '../../pages/appointments/booked_appointment_detail'
require_relative '../../module/DateUtility'
require_relative '../../pages/user_menu'
require_relative '../../module/database/OracleUtility'
require_relative '../../common/cancel_appointment'


describe '[Story# VAR-12201: Expand/collapse Accordion link associated with Date/Time generates Confirmation warning Modal]'  do
  include DriverUtility
  include OracleUtility


  before(:all) do
    initializeConfigurations(VAR_BASE_URL)
    @landing_appointments = LandingAppointments.new(@driver)
    @landing = Landing.new(@driver)
    @login = Login.new(@driver)
    @common = Common.new(@driver)
    @eula = Eula.new(@driver)
    @user_menu = UserMenuOption.new(@driver)
    @modal = Modal.new(@driver)
    @new_appointment = NewAppointmentRequest.new(@driver)
    @detail = BookedAppointmentDetail.new(@driver)
    APPOINTMENTS = "Appointments/Requests"
    @sevenDaysFromNow = getDateNthDaysFromNow(7, "%m/%d/%Y")
    @@timeSlot = "11:00"
    #cancel existing appointment
    @cancel_appointment = CancelAppointment.new("CLINIC_BASED_BOSTON", "523","#{pw_redacted['userid']}")
    @cancel_appointment.update_appointment_obj("appointmentTime", "#{@sevenDaysFromNow} 11:00:00")
    @cancel_appointment.cancel_appointment()


  end

  after(:all) do
    @driver.close
  end

  context '[AC#VAR-12201|TC#VAR-: Validate expand collapse accordion]'do

    it "Verify date element can be collapsed" do
      @common.loginEndsOnHome(pw_redacted)
      @common.selectAddAppointmentButton("VA")
      @new_appointment.selectNewAppointmentAndSchedule(PRIMARY_CARE, "523", "523", "direct")
      @new_appointment.selectClinic("32")
      @new_appointment.provideReasonForAppointment("This is new switched clinic")
      @new_appointment.selectPreferedDate(@sevenDaysFromNow, @@timeSlot)
      @@setDate = NewAppointmentRequest.bookedDate
      @new_appointment.show_availability
      expect(@new_appointment.getDateElement(@@setDate).text).to include("select to collapse content")

    end

    it "Verify collapsing the accordion does not load confirmation pop up" do
      @new_appointment.collapse_slots
      @common.waitWhileSpinnerPresent
      expect(@new_appointment.getDateElement(@@setDate).text).to include("select to expand content")

    end
  end
end









